require( "HiddenObject/script/style.lua" );


MyFont = {
  standardFont,
  30,
  WhiteColor
};

NameFont = {
  standardFont,
  20,
  WhiteColor
};


WelcomeTextFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  32,
  Color(131, 167, 184, 255)
};

local playername = gEnterNameValue;
local deleteselected = false;

if not playername or playername=="" then
	deleteselected = true;
	playername = GetString("enternameprompt") ;
end


OkGraphics = {
	"HiddenObject/UI/Button/oknormal.png",
	"HiddenObject/UI/Button/okdown.png",
	"HiddenObject/UI/Button/okover.png",
};	

OkStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = ButtonFont,
	graphics = OkGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};
MakeDialog
{
	Bitmap
	{
		image="HiddenObject/UI/LoadScreen/loadscreen",
		x=kCenter,
		y=kCenter,

		Bitmap
		{
			image="HiddenObject/UI/Background/nocturnallogo",
			x=0,
			y=440,		
		},
		
		Bitmap
		{
			image="HiddenObject/UI/Background/smalldialog",
			x=kCenter,
			y=kCenter,
			
		
			Text
			{
				font = WelcomeTextFont ,
				name = "welcome2nocturnal",
				x=kCenter,y=20,w=kMax,h=36,
				flags = kHAlignCenter + kVAlignCenter,
				label = "welcome2nocturnal"
			},


		};

		Bitmap
		{
			image="HiddenObject/UI/Background/textfield.png",
			x=kCenter,
			y=kCenter,

			TextEdit
			{
				font = NameFont,
				name = "nameedit",
				label = playername,
				enablewindow = "enterok",
				clearinitial = true,
				x=3,y=5,w=kMax-3,h=kMax,
				length=12,
				ignore = kIllegalNameChars

			};
		};
		

		SetStyle(OkStyle),
		Button
		{
			x=kCenter,
			y=kCenter+75,
			font = StandardButtonFont,
			name="enterok",
			label="ok",
			type = kPush,
			default=true,	-- Make this the default button
			command =
				function()
					local newname = GetLabel("nameedit");
 
					if (IsNameInUse(newname, -1, true)) then
						DisplayDialog {
							"HiddenObject/script/centeredok.lua",
							body ="nameinuse",
							title = ""
						};
						SetFocus( "nameedit" )
					else 
						if (IsNameInvalid(newname))then
							DisplayDialog 
							{
								"HiddenObject/script/centeredok.lua",
								body ="invalidname",
								title = "invalidnametitle"
							};
							SetFocus( "nameedit" )
						else
							CloseWindow(GetLabel("nameedit"));
						end
					end
				end
		},

	},

}

SetFocus( "nameedit" );

if (deleteselected) then
	EnableWindow("enterok", false);
end


